# New Appointment Requests 

*Note: This folder is using a different file structure than most other modules on this project. The reason for this is that by sperating the models and the views into separate directories it is easier to adhere to basic MVC principles. This change was made in the story VAR-10192, and one of the goals of that story was to help draw clearer boundaries between the data and the displaying of that data*


The structure of this folder is broken down into three basic parts 
1. Common Components - These are aspects of the form that are the same regardless of it direct scheduling or request scheduling is being used
2. Direct Components - These are items that a specific to direct (appointment) scheduling and have no impact on request scheduling
3. Request Components - Like direct components, these items have no overlap.  They only impact the request portion of the form.

## Views 

1. section-view.js - The form component itself, extends question-view.js
2. header.js - A small item-view responsible for drawing the common headings of the views 
3. layout-view.js - Typically a view that controls the combination of the header and the section view. 

## Models 
In general all views in this folder share a single common model (resources/common/model), but hold their own independent collection. 
The model is build dynamically as each view add another independent view specific model into the common model as the user selects items. 
The common model also adds short cuts for accessing data from other models that it holds.  In general each view should only write to their own nested model, but read from any that they need too. 

The common model is use primarily for eventing. 

The direct/request model, extend the common model and is used for write back. 

```javascript
var directModel = new DirectModel(commonModel.attributes);
directModel.save();
```

# Example of adding a new view

The following is an example of adding a new common view:
 
```javascript
// main.js
define(['marionette', 'common/model', 'views/layout'], function(Mn, Model, LayoutView) {
    'use strict';
    
    return Mn.View.extend({
        regions: {
            layout: '#layout'
        },
        
        modelEvents: {
            'change:whatever': 'doWhatever'
        },
        
        initialize: function() {
            this.model = new Model();
        },
        
        onRender: function() {
            var region = this.getRegion('layout');
            region.show(new LayoutView({
                model: this.model
            }));
        },
        
        doWhatever: function() { /* .. */ }
    })
    
});


// collection.js
define(['backbone', 'models/abstract-collection'], function(Backbone, Collection) {
    'use strict';
    
    // abstract-collection and abstract-model should be used when you are communicating with the API
    // otherwise, an normal Backbone.Collection/Model is fine.
    
    // You can customize your collections and models all you want
    var Model = Backbone.Model.extend({ 
        
        // not needed but should probably set this when possible
        // 'value' should correspond to the form 'value'
        idAttribute: 'value'
        
        /* .. */ 
    });
    
    // The abstract collection and model is written in such a way so that it should
    // be safe to do anything you want with it without worrying about breaking its functionality
    // treat them like any other backbone model or collection.
    return Collection.extend({
        resourceName: 'whatever-resources',
        model: Model
        /* .. */
    })
});


// layout.js
define(['marionette', 'this/view/collection', 'view/section', 'view/header'], function(Mn, Collection, Section, Header) {
    'use strict';
    
    return Mn.View.extend({
        region: {
            header: '#header',
            section: '#section'
        },
    
        initialize: function() {
            this.collection = new Collection();
            this.listenTo(this.collection, 'fetch:success', this.onSuccess); 
            this.collection.fetch();
        },
        
        // Anything extending the abstract collection or model will fire a success or error event
        // When the request comes back from the server
        onSuccess: function() {
            var region = this.getRegion('section');
            region.show(new Section({
                model: this.model,
                
                // this.collection is reserved in the QuestionView :( 
                // any name is fine here, and in most case 'data' is too generic 
                data: this.collection
            }))
        },
        
        // Header can be shown without waiting on anything else
        onRender: function() {
            var region = this.getRegion('header'); 
            region.show(new Header())
        }
    });
    
});


// section.js
define(['question-view'], function(QV) {
    'use strict';
    
    return QV.extend({
        collectionEvents: {
            'change:value': 'updateFDNS   el'
        },
        
        // Normal Setup
        
        updateFDNS   el: function(model) {
            var id = model.get('value');
            
            // this.data hold the collection from the layout-view
            var collectionModel = this.data.get(id)
            
            // Set the entire model, and not just the value
            this.model.set('whatever', collectionModel);
            // The specific values needed for writeback should be extracted  
            // during writeback.  This is better because it keeps each views information
            // unique, while at the same time offer access to any other view that may need that 
            // same information.  
        }
    })
});
```